/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.flag.FlagCorrelation;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.group.GroupType;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.DimensionalRegion;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import de.z0rdak.yawp.data.region.DimensionRegionCache;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.text.Messages;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import org.apache.commons.lang3.NotImplementedException;

public class ChatLinkBuilder {
    private ChatLinkBuilder() {
    }

    public static class_5250 buildAreaMarkedBlocksTpLinks(IMarkableRegion region) {
        List<class_5250> tpLinks = region.getArea().markedBlocks().stream().map(pos -> ChatLinkBuilder.buildDimensionalBlockTpLink(region.getDim(), pos, class_2561.method_43470((String)ChatComponentBuilder.commandBlockPosStr(pos)))).toList();
        class_5250 blockPosTpLinkList = class_2561.method_43470((String)"");
        tpLinks.forEach(tpLink -> blockPosTpLinkList.method_10852((class_2561)tpLink).method_27693(" "));
        return blockPosTpLinkList;
    }

    public static class_5250 buildRegionAreaExpandLink(IMarkableRegion region) {
        class_5250 linkText = class_2561.method_48321((String)"cli.msg.info.region.area.area.expand.link.text", (String)"<=expand=>");
        class_5250 linkHover = class_2561.method_48322((String)"cli.msg.info.region.area.area.expand.link.hover", (String)"Expand the area for '%s'", (Object[])new Object[]{region.getName()});
        String expandCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.AREA.toString(), CommandConstants.EXPAND.toString(), region.getArea().getAreaType().areaType);
        switch (region.getArea().getAreaType()) {
            case CUBOID: {
                CuboidArea cuboidArea = (CuboidArea)region.getArea();
                int areaLowerLimit = cuboidArea.getArea().method_35416();
                int areaUpperLimit = cuboidArea.getArea().method_35419();
                String expandCmdSuggestion = Commands.appendSubCommand(expandCmd, String.valueOf(areaLowerLimit), String.valueOf(areaUpperLimit));
                class_5250 expandLink = ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, linkHover, expandCmdSuggestion, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
                class_5250 maxExpandLinkText = class_2561.method_48321((String)"cli.msg.info.region.area.area.expand-max.link.text", (String)"<=max=>");
                class_5250 maxExpandLinkHover = class_2561.method_48321((String)"cli.msg.info.region.area.area.expand-max.link.hover", (String)"Expand area to build limit");
                String maxExpandCmd = Commands.appendSubCommand(expandCmd, String.valueOf(-64), String.valueOf(320));
                class_5250 maxExpandLink = ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(maxExpandLinkText, maxExpandLinkHover, maxExpandCmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
                return Messages.substitutable("%s %s", expandLink, maxExpandLink);
            }
            case CYLINDER: {
                throw new NotImplementedException("cylinder");
            }
            case SPHERE: {
                String expandCmdSuggestion = Commands.appendSubCommand(expandCmd, String.valueOf(1));
                return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, linkHover, expandCmdSuggestion, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
            }
            case POLYGON_3D: {
                throw new NotImplementedException("polygon");
            }
            case PRISM: {
                throw new NotImplementedException("prism");
            }
        }
        throw new IllegalArgumentException("Invalid area type");
    }

    private static class_5250 buildShowAreaToggleLink(IMarkableRegion region) {
        class_5250 showAreaLinkText = class_2561.method_48321((String)"cli.msg.info.region.area.area.show.link", (String)"Show");
        class_5250 showAreaLinkHover = class_2561.method_48322((String)"cli.msg.info.region.area.area.show.hover", (String)"Toggle visible bounding box of '%s'", (Object[])new Object[]{region.getName()});
        String showAreaCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.AREA.toString(), "show");
        return ChatComponentBuilder.buildExecuteCmdComponent(showAreaLinkText, showAreaLinkHover, showAreaCmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildAreaUpdateLink(IMarkableRegion region) {
        class_5250 setAreaLinkText = class_2561.method_48321((String)"cli.msg.info.region.area.area.set.link", (String)"set area");
        class_5250 setAreaLinkHover = class_2561.method_48322((String)"cli.msg.info.region.area.area.set.hover", (String)"Update area of region '%s'", (Object[])new Object[]{region.getName()});
        String blocks = String.join((CharSequence)" ", region.getArea().markedBlocks().stream().map(ChatComponentBuilder::commandBlockPosStr).collect(Collectors.toSet()));
        String setAreaCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.AREA.toString(), CommandConstants.SET.toString(), region.getArea().getAreaType().areaType, blocks);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(setAreaLinkText, setAreaLinkHover, setAreaCmd, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }

    public static class_5250 buildRegionAreaActionLinks(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.area.show.link.text", (String)"show area");
        return Messages.substitutable("%s %s %s", ChatLinkBuilder.buildAreaUpdateLink(region), ChatLinkBuilder.buildRegionShowVisualizationLink(region, text), ChatLinkBuilder.buildRegionAreaExpandLink(region));
    }

    public static class_5250 buildWikiLink() {
        class_5250 wikiLinkHover = class_2561.method_48321((String)"help.tooltip.wiki.link.hover", (String)"https://github.com/Z0rdak/Yet-Another-Level-Protector/wiki");
        class_5250 wikiLink = class_2561.method_48321((String)"help.tooltip.wiki.link.text", (String)"Open Wiki in default browser");
        return ChatComponentBuilder.buildExecuteCmdComponent(wikiLink, wikiLinkHover, "https://github.com/Z0rdak/Yet-Another-World-Protector/wiki", class_2558.class_2559.field_11749, class_124.field_1075);
    }

    public static class_5250 buildRegionInfoLink(IProtectedRegion region) {
        return ChatLinkBuilder.buildRegionInfoLink(region, class_2561.method_48322((String)"cli.msg.info.region.link.hover", (String)"Show region info for %s", (Object[])new Object[]{region.getName()}));
    }

    public static class_5250 buildRegionInfoLink(IProtectedRegion region, class_5250 linkText, class_5250 hoverText) {
        String cmd = Commands.buildRegionInfoCmd(region);
        return ChatComponentBuilder.buildExecuteCmdLink(linkText, hoverText, cmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildRegionInfoLink(IProtectedRegion region, class_5250 hoverText) {
        class_5250 linkText = class_2561.method_43470((String)region.getName());
        return ChatLinkBuilder.buildRegionInfoLink(region, linkText, hoverText);
    }

    public static class_5250 buildRegionAreaLink(IMarkableRegion region) {
        String showSpatialPropLink = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.AREA.toString());
        class_5250 spatialPropLinkText = class_2561.method_48321((String)"cli.msg.info.region.area.link.text", (String)"Area Properties");
        class_5250 spatialPropHoverText = class_2561.method_48322((String)"cli.msg.info.region.area.link.hover", (String)"Show region area properties for %s", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLink(spatialPropLinkText, spatialPropHoverText, showSpatialPropLink, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildDisplaySettingsLink(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.display.link.text", (String)"Display settings");
        return ChatLinkBuilder.buildDisplaySettingsLink(region, text);
    }

    public static class_5250 buildRegionShowVisualizationLink(IMarkableRegion region, class_5250 text) {
        String showDisplayPropLink = Commands.buildShowCommand(region);
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.visualization.link.hover", (String)"Click to show visualization options for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, showDisplayPropLink, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildRegionVisualizationLink(IMarkableRegion region) {
        String showDisplayPropLink = Commands.buildShowCommand(region);
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.visualization.link.text", (String)"Visualization");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.visualization.link.hover", (String)"Click to show visualization options for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLink(text, hover, showDisplayPropLink, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildDisplaySettingsLink(IMarkableRegion region, class_5250 text) {
        String showDisplayPropLink = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.DISPLAY.toString());
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.display.link.hover", (String)"Click to show display settings for '%s'", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLink(text, hover, showDisplayPropLink, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildGroupLink(IProtectedRegion region, String group, int groupSize) {
        class_5250 linkText = class_2561.method_48322((String)"cli.msg.info.region.group.list.link.text", (String)"%s %s(s)", (Object[])new Object[]{groupSize, group});
        class_5250 hoverText = class_2561.method_48322((String)"cli.msg.info.region.group.list.link.hover", (String)"List '%s' for region %s", (Object[])new Object[]{group, region.getName()});
        String cmd = Commands.buildListGroupCommand(region, group);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildPlayerListLink(IProtectedRegion region, PlayerContainer players, String group) {
        class_5250 hoverText = class_2561.method_48322((String)"cli.msg.info.region.group.player.list.link.hover", (String)"List players of group '%s' in region %s", (Object[])new Object[]{group, region.getName()});
        class_5250 linkText = class_2561.method_48322((String)"cli.msg.info.region.group.player.list.link.text", (String)"%s player(s)", (Object[])new Object[]{players.getPlayers().size()});
        String cmd = Commands.buildListGroupMemberCommand(region, group, GroupType.PLAYER);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildTeamListLink(IProtectedRegion region, PlayerContainer teams, String group) {
        class_5250 hoverText = class_2561.method_48322((String)"cli.msg.info.region.group.team.list.link.hover", (String)"List teams of group '%s' in region %s", (Object[])new Object[]{group, region.getName()});
        class_5250 linkText = class_2561.method_48322((String)"cli.msg.info.region.group.team.list.link.text", (String)"%s team(s)", (Object[])new Object[]{teams.getTeams().size()});
        String cmd = Commands.buildListGroupMemberCommand(region, group, GroupType.TEAM);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildAddToGroupLink(IProtectedRegion region, String group, GroupType groupType) {
        class_5250 linkText = class_2561.method_48321((String)"cli.link.add", (String)"+");
        String fallback = "Add " + groupType.name + " as '%s' to region %s";
        class_5250 hoverText = class_2561.method_48322((String)("cli.msg.info.region.group." + groupType.name + ".add.link.hover"), (String)fallback, (Object[])new Object[]{group, region.getName()});
        String cmd = Commands.buildAddGroupMemberCommand(region, groupType, group, "");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }

    public static class_5250 buildGroupTeamListLink(IProtectedRegion region, String group) {
        PlayerContainer playerContainer = region.getGroup(group);
        class_5250 teamAddLink = ChatLinkBuilder.buildAddToGroupLink(region, group, GroupType.TEAM);
        class_5250 teamListLink = playerContainer.hasTeams() ? ChatLinkBuilder.buildTeamListLink(region, playerContainer, group) : class_2561.method_48322((String)"cli.msg.info.region.group.team.list.link.text", (String)"%s team(s)", (Object[])new Object[]{playerContainer.getTeams().size()});
        return Messages.substitutable("%s: %s %s", class_2561.method_48321((String)"cli.msg.info.region.group.team", (String)"Teams"), teamListLink, teamAddLink);
    }

    public static class_5250 buildGroupPlayerListLink(IProtectedRegion region, String group) {
        PlayerContainer playerContainer = region.getGroup(group);
        class_5250 playersAddLink = ChatLinkBuilder.buildAddToGroupLink(region, group, GroupType.PLAYER);
        class_5250 playerListLink = playerContainer.hasPlayers() ? ChatLinkBuilder.buildPlayerListLink(region, playerContainer, group) : class_2561.method_48322((String)"cli.msg.info.region.group.player.list.link.text", (String)"%s player(s)", (Object[])new Object[]{playerContainer.getPlayers().size()});
        return Messages.substitutable("%s: %s %s", class_2561.method_48321((String)"cli.msg.info.region.group.player", (String)"Players"), playerListLink, playersAddLink);
    }

    public static class_5250 buildFlagInfoLink(IProtectedRegion region, IFlag flag, class_124 linkColor) {
        class_5250 text = class_2561.method_43470((String)flag.getName());
        class_5250 hoverText = class_2561.method_48322((String)"cli.flag.info.hover", (String)"Show %s flag info of region '%s'", (Object[])new Object[]{flag.getName(), region.getName()});
        return ChatLinkBuilder.buildFlagInfoLink(region, flag, text, hoverText, linkColor);
    }

    public static class_5250 buildFlagInfoLink(IProtectedRegion region, IFlag flag, class_5250 text, class_5250 hoverText, class_124 linkColor) {
        String cmd = Commands.buildFlagInfoCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hoverText, cmd, class_2558.class_2559.field_11750, linkColor);
    }

    public static class_5250 buildFlagInfoLink(IProtectedRegion region, IFlag flag) {
        return ChatLinkBuilder.buildFlagInfoLink(region, flag, Messages.LINK_COLOR);
    }

    public static class_5250 buildFlagStateSuggestionLink(IProtectedRegion region, IFlag flag) {
        class_5250 hover = class_2561.method_48322((String)"cli.flag.state.set.link.hover", (String)"Set flag state for '%s' in '%s'", (Object[])new Object[]{flag.getName(), region.getName()});
        class_5250 text = class_2561.method_48321((String)"cli.flag.state.set.link.text", (String)"s");
        String cmd = Commands.buildFlagSuggestStateCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }

    public static class_5250 buildFlagOverrideToggleLink(IProtectedRegion region, IFlag flag, boolean shortLink) {
        String fallback = flag.doesOverride() ? "active" : "inactive";
        String fallbackHover = (flag.doesOverride() ? "Disable" : "Enable") + " flag override for '%s' of '%s'";
        class_5250 linkText = class_2561.method_48321((String)("cli.flag.override.link.text." + flag.doesOverride()), (String)fallback);
        class_5250 hoverText = class_2561.method_48322((String)("cli.flag.override.link.hover." + flag.doesOverride()), (String)fallbackHover, (Object[])new Object[]{flag.getName(), region.getName()});
        if (shortLink) {
            linkText = class_2561.method_48321((String)"cli.flag.override.link.text.toggle", (String)"o");
        }
        class_124 color = flag.doesOverride() ? class_124.field_1060 : class_124.field_1080;
        String cmd = Commands.buildFlagOverrideToggleCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(linkText, hoverText, cmd, class_2558.class_2559.field_11750, color);
    }

    public static class_5250 buildFlagMessageEditLink(IProtectedRegion region, IFlag flag) {
        class_5250 hover = class_2561.method_48322((String)"cli.flag.msg.text.set.link.hover", (String)"Change the message shown when the flag '%s' of '%s' is triggered", (Object[])new Object[]{flag.getName(), region.getName()});
        class_5250 text = class_2561.method_48321((String)"cli.flag.msg.text.set.link.text", (String)"Edit");
        String msg = "\"" + flag.getFlagMsg().msg() + "\"";
        String cmd = Commands.buildFlagMsgSetCmd(region, flag.getName(), msg);
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }

    public static class_5250 buildFlagMessageClearLink(IProtectedRegion region, IFlag flag) {
        class_5250 hover = class_2561.method_48322((String)"cli.flag.msg.text.set.default", (String)"Reset flag message for flag '%s' of '%s' to config default", (Object[])new Object[]{flag.getName(), region.getName()});
        class_5250 text = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        String cmd = Commands.buildFlagMsgClearCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
    }

    public static class_5250 buildFlagMuteToggleLink(IProtectedRegion region, IFlag flag, boolean shortLink) {
        String fallback = !flag.getFlagMsg().isMuted() ? "inactive" : "active";
        class_5250 hover = class_2561.method_48322((String)"cli.flag.msg.mute.set.link.hover", (String)"Activate flag alert for '%s' in '%s'", (Object[])new Object[]{flag.getName(), region.getName()});
        class_5250 text = class_2561.method_48321((String)("cli.flag.msg.mute.set.link.text." + !flag.getFlagMsg().isMuted()), (String)fallback);
        if (shortLink) {
            text = class_2561.method_48321((String)"cli.flag.msg.mute.set.link.text.toggle", (String)"m");
        }
        class_124 textChatFormatting = !flag.getFlagMsg().isMuted() ? class_124.field_1060 : class_124.field_1080;
        String cmd = Commands.buildFlagMsgMuteToggleCmd(region, flag.getName());
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, class_2558.class_2559.field_11750, textChatFormatting);
    }

    public static class_5250 buildRemoveAllRegionsAttemptLink(DimensionRegionCache dimCache) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimCache.getDimensionalRegion().getName(), CommandConstants.DELETE_ALL.toString(), CommandConstants.REGIONS.toString());
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.dim.region.remove.all.link.hover", (String)"Remove all regions from %s", (Object[])new Object[]{dimCache.getDimensionalRegion().getName()});
        class_5250 text = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRemoveAllRegionsLink(DimensionRegionCache dimCache) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimCache.getDimensionalRegion().getName(), CommandConstants.DELETE_ALL.toString(), CommandConstants.REGIONS.toString(), CommandConstants.FOREVER.toString(), CommandConstants.SERIOUSLY.toString());
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.dim.region.remove.all.link.hover", (String)"Remove all regions from %s", (Object[])new Object[]{dimCache.getDimensionalRegion().getName()});
        class_5250 text = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRemoveRegionLink(IProtectedRegion region) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().method_29177().toString(), CommandConstants.DELETE.toString(), region.getName(), "-y");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.dim.region.remove.link.hover", (String)"Remove region %s", (Object[])new Object[]{region.getName()});
        class_5250 text = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
    }

    public static class_5250 buildParentClearLink(IMarkableRegion region) {
        String clearRegionParentCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.PARENT.toString(), CommandConstants.REMOVE.toString());
        class_5250 parentClearLinkText = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        class_5250 parentClearHoverText = class_2561.method_48322((String)"cli.msg.info.region.parent.clear.link.hover", (String)"Clear '%s' as parent region", (Object[])new Object[]{region.getParent().getName()});
        return ChatComponentBuilder.buildExecuteCmdComponent(parentClearLinkText, parentClearHoverText, clearRegionParentCmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
    }

    private static class_5250 createParentAddLink(IProtectedRegion region) {
        String setRegionParentCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.PARENT.toString(), CommandConstants.SET.toString(), "");
        class_5250 setParentLinkText = class_2561.method_48321((String)"cli.link.add", (String)"+");
        class_5250 setParentHoverText = class_2561.method_48322((String)"cli.msg.info.region.parent.set.link.hover", (String)"Set parent for region %s", (Object[])new Object[]{region.getName()});
        return Messages.substitutable("%s %s", class_2561.method_48321((String)"cli.msg.info.region.parent.null", (String)"No parent set"), ChatComponentBuilder.buildExecuteCmdComponent(setParentLinkText, setParentHoverText, setRegionParentCmd, class_2558.class_2559.field_11750, class_124.field_1060));
    }

    public static class_5250 buildDimRegionsLink(DimensionRegionCache dimCache) {
        DimensionalRegion dimRegion = dimCache.getDimensionalRegion();
        String command = Commands.buildCommandStr(CommandConstants.DIM.toString(), dimRegion.getDim().method_29177().toString(), CommandConstants.LIST.toString(), CommandConstants.LOCAL.toString());
        class_5250 text = class_2561.method_48322((String)"cli.msg.dim.info.region.list.link.text", (String)"%s region(s)", (Object[])new Object[]{dimCache.getRegionCount()});
        class_5250 hover = class_2561.method_48322((String)"cli.msg.dim.info.region.list.link.hover", (String)"List regions in %s", (Object[])new Object[]{dimRegion.getName()});
        class_5250 listLocalRegionsLink = ChatComponentBuilder.buildExecuteCmdComponent(text, hover, command, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
        class_5250 createRegionLink = ChatLinkBuilder.buildDimCreateRegionLink(dimRegion);
        if (dimRegion.getChildren().isEmpty()) {
            return Messages.substitutable("%s %s", text, createRegionLink);
        }
        return Messages.substitutable("%s %s", listLocalRegionsLink, createRegionLink);
    }

    public static class_5250 buildRegionListChildrenLink(IProtectedRegion region) {
        class_5250 text = class_2561.method_48322((String)"cli.msg.info.region.children.list.link.text", (String)"%s child regions(s)", (Object[])new Object[]{region.getChildren().size()});
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.children.list.link.hover", (String)"List direct child regions of '%s'", (Object[])new Object[]{region.getName()});
        String command = Commands.buildListChildRegionCommand(region);
        return switch (region.getRegionType()) {
            case RegionType.GLOBAL -> {
                Set<String> dimensionList = RegionDataManager.get().getDimensionList();
                class_5250 listDimRegionsLinkText = class_2561.method_48322((String)"cli.msg.global.info.region.list.link.text", (String)"%s dimensions(s)", (Object[])new Object[]{dimensionList.size()});
                class_5250 listDimRegionsHoverText = class_2561.method_48321((String)"cli.msg.global.info.region.list.link.hover", (String)"List all Dimensional Regions");
                yield ChatComponentBuilder.buildExecuteCmdComponent(listDimRegionsLinkText, listDimRegionsHoverText, command, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
            }
            case RegionType.DIMENSION -> {
                class_5250 listDimRegionsListLink = ChatComponentBuilder.buildExecuteCmdComponent(text, hover, command, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
                if (region.getChildren().isEmpty()) {
                    yield Messages.substitutable("%s %s", text, ChatLinkBuilder.buildDimCreateRegionLink(region));
                }
                yield Messages.substitutable("%s %s", listDimRegionsListLink, ChatLinkBuilder.buildDimCreateRegionLink(region));
            }
            case RegionType.LOCAL -> {
                class_5250 regionChildrenLink = ChatComponentBuilder.buildExecuteCmdComponent(text, hover, command, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
                class_5250 addChildrenLink = ChatLinkBuilder.buildRegionAddChildrenLink(region);
                if (region.getChildren().isEmpty()) {
                    yield Messages.substitutable("%s %s", text, addChildrenLink);
                }
                yield Messages.substitutable("%s %s", regionChildrenLink, addChildrenLink);
            }
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)region.getRegionType()));
        };
    }

    public static class_5250 buildRegionAddChildrenLink(IProtectedRegion region) {
        String addChildrenCmd = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.ADD.toString(), CommandConstants.CHILD.toString(), "");
        class_5250 addChildrenLinkText = class_2561.method_48321((String)"cli.link.add", (String)"+");
        class_5250 addChildrenHoverText = class_2561.method_48322((String)"cli.msg.info.region.children.add.link.hover", (String)"Add child to region %s", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdComponent(addChildrenLinkText, addChildrenHoverText, addChildrenCmd, class_2558.class_2559.field_11745, Messages.ADD_CMD_COLOR);
    }

    public static class_5250 buildDimCreateRegionLink(IProtectedRegion region) {
        String dimCreateRegionCmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().method_29177().toString(), CommandConstants.CREATE.toString(), CommandConstants.LOCAL.toString(), "");
        class_5250 createRegionLinkText = class_2561.method_48321((String)"cli.link.add", (String)"+");
        class_5250 createRegionHoverText = class_2561.method_48322((String)"cli.msg.dim.info.region.create.link.hover", (String)"Create region in dimension %s", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdComponent(createRegionLinkText, createRegionHoverText, dimCreateRegionCmd, class_2558.class_2559.field_11745, Messages.ADD_CMD_COLOR);
    }

    public static class_5250 buildResponsibleFlagListLink(IProtectedRegion region) {
        Map<String, FlagCorrelation> flagsInHierarchy = HandlerUtil.getFlagMapRecursive(region, null);
        class_5250 responsibleFlagsNumber = ChatComponentBuilder.buildTextWithHoverMsg(Messages.substitutable("%s", flagsInHierarchy.size()), class_2561.method_48322((String)"cli.msg.info.region.flag.responsible.number.hover", (String)"%s flag(s) applicable for %s", (Object[])new Object[]{flagsInHierarchy.size(), region.getName()}), Messages.LINK_COLOR);
        class_5250 responsibleFlagListHoverText = class_2561.method_48322((String)"cli.msg.info.region.flag.responsible.link.hover", (String)"Show responsible region flags for %s", (Object[])new Object[]{region.getName()});
        String flagListCmd = Commands.buildListFlagsCommand(region);
        class_5250 responsibleFlagListLink = ChatComponentBuilder.buildExecuteCmdComponent(responsibleFlagsNumber, responsibleFlagListHoverText, flagListCmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
        class_5250 responsibleFlagsComp = flagsInHierarchy.isEmpty() ? responsibleFlagsNumber : responsibleFlagListLink;
        return class_2561.method_48322((String)"cli.msg.info.region.flag.responsible.link.text", (String)"%s responsible flag(s)", (Object[])new Object[]{responsibleFlagsComp});
    }

    public static class_5250 buildRegionFlagListLink(IProtectedRegion region) {
        class_5250 regionFlagNumber = ChatComponentBuilder.buildTextWithHoverMsg(Messages.substitutable("%s", region.getFlags().size()), class_2561.method_48322((String)"cli.msg.info.region.flag.number.hover", (String)"%s flag(s) in %s", (Object[])new Object[]{region.getFlags().size(), region.getName()}), Messages.LINK_COLOR);
        class_5250 flagListHoverText = class_2561.method_48322((String)"cli.msg.info.region.flag.link.hover", (String)"%s flag(s) in %s", (Object[])new Object[]{region.getFlags().size(), region.getName()});
        String regionFlagListCmd = Commands.buildListRegionFlagsCommand(region);
        class_5250 regionFlagListLink = ChatComponentBuilder.buildExecuteCmdComponent(regionFlagNumber, flagListHoverText, regionFlagListCmd, class_2558.class_2559.field_11750, Messages.LINK_COLOR);
        class_5250 regionFlagsComp = region.getFlags().isEmpty() ? regionFlagNumber : regionFlagListLink;
        return Messages.substitutable("%s %s", class_2561.method_48322((String)"cli.msg.info.region.flag.region.link.text", (String)"%s flag(s)", (Object[])new Object[]{regionFlagsComp}), ChatLinkBuilder.buildSuggestAddFlagLink(region));
    }

    public static class_5250 buildSuggestAddFlagLink(IProtectedRegion region) {
        return ChatLinkBuilder.buildAddFlagLink(region, "", class_2558.class_2559.field_11745);
    }

    public static class_5250 buildAddFlagLink(IProtectedRegion region, String flag) {
        return ChatLinkBuilder.buildAddFlagLink(region, flag, class_2558.class_2559.field_11750);
    }

    public static class_5250 buildAddFlagLink(IProtectedRegion region, String flag, class_2558.class_2559 action) {
        class_5250 hoverText = class_2561.method_48322((String)"cli.msg.info.region.flag.add.link.hover", (String)"Add new flag to region %s", (Object[])new Object[]{region.getName()});
        class_5250 linkText = class_2561.method_48321((String)"cli.link.add", (String)"+");
        String cmd = Commands.buildAddFlagCommand(region, flag);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, action, Messages.ADD_CMD_COLOR);
    }

    public static class_5250 buildDimensionalBlockTpLink(class_5321<class_1937> dim, class_2338 target) {
        String teleportCmd = ChatComponentBuilder.buildTeleportCmd(dim, "@s", target);
        class_5250 text = class_2561.method_48322((String)"cli.msg.info.region.area.tp.block.link.text", (String)"%s", (Object[])new Object[]{ChatComponentBuilder.buildBlockPosLinkText(target)});
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.area.tp.block.link.hover", (String)"Click to teleport to %s", (Object[])new Object[]{ChatComponentBuilder.shortBlockPosBracketed(target)});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, teleportCmd, class_2558.class_2559.field_11750, Messages.TP_COLOR);
    }

    public static class_5250 buildDimensionalBlockTpLink(class_5321<class_1937> dim, class_2338 target, class_5250 text) {
        String teleportCmd = ChatComponentBuilder.buildTeleportCmd(dim, "@s", target);
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.area.tp.block.link.hover", (String)"Click to teleport to %s", (Object[])new Object[]{ChatComponentBuilder.shortBlockPosBracketed(target)});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, teleportCmd, class_2558.class_2559.field_11750, Messages.TP_COLOR);
    }

    public static class_5250 buildDimensionalBlockTpLink(class_5321<class_1937> dim, class_2338 target, class_5250 text, class_5250 hover) {
        String teleportCmd = ChatComponentBuilder.buildTeleportCmd(dim, "@s", target);
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, teleportCmd, class_2558.class_2559.field_11750, Messages.TP_COLOR);
    }

    public static class_5250 buildDimSuggestRegionRemovalLink(IMarkableRegion region) {
        String cmd = Commands.buildCommandStr(CommandConstants.DIM.toString(), region.getDim().method_29177().toString(), CommandConstants.DELETE.toString(), region.getName());
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.dim.region.remove.link.hover", (String)"Remove region %s", (Object[])new Object[]{region.getName()});
        class_5250 text = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, cmd, class_2558.class_2559.field_11745, Messages.REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRegionRemoveChildLink(IProtectedRegion region, IProtectedRegion child) {
        String command = Commands.buildCommandStr(CommandConstants.LOCAL.toString(), region.getDim().method_29177().toString(), region.getName(), CommandConstants.REMOVE.toString(), CommandConstants.CHILD.toString(), child.getName());
        class_5250 linkText = class_2561.method_48321((String)"cli.link.remove", (String)"x");
        class_5250 linkHoverText = class_2561.method_48322((String)"cli.msg.info.region.children.remove.link.hover", (String)"Remove child '%s' from region %s", (Object[])new Object[]{child.getName(), region.getName()});
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, linkHoverText, command, class_2558.class_2559.field_11745, Messages.REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRegionActionUndoLink(String cmd, CommandConstants toReplace, CommandConstants replacement) {
        String revertCmd = ArgumentUtil.revertCommand(cmd, toReplace, replacement);
        class_5250 revertLinkText = class_2561.method_48321((String)"cli.link.action.undo.text", (String)"<-");
        class_5250 revertLinkHover = class_2561.method_48321((String)"cli.link.action.undo.hover", (String)"Undo action.");
        return ChatComponentBuilder.buildExecuteCmdComponent(revertLinkText, revertLinkHover, revertCmd, class_2558.class_2559.field_11750, class_124.field_1079);
    }

    public static class_5250 buildRegionActionUndoLink(String cmd, String toReplace, String replacement) {
        String revertCmd = ArgumentUtil.revertCommand(cmd, toReplace, replacement);
        class_5250 revertLinkText = class_2561.method_48321((String)"cli.link.action.undo.text", (String)"<-");
        class_5250 revertLinkHover = class_2561.method_48321((String)"cli.link.action.undo.hover", (String)"Undo action.");
        return ChatComponentBuilder.buildExecuteCmdComponent(revertLinkText, revertLinkHover, revertCmd, class_2558.class_2559.field_11750, class_124.field_1079);
    }

    public static class_5250 buildRemoveGroupMemberLink(IProtectedRegion region, String name, GroupType groupType, String group, class_5250 linkText, class_5250 hoverText) {
        String cmd = Commands.buildRemoveGroupMemberCommand(region, groupType, group, name);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
    }

    public static class_5250 buildRemoveLinkForOfflinePlayer(IProtectedRegion region, String name, GroupType groupType, String group, class_5250 linkText, class_5250 hoverText) {
        String cmd = Commands.buildRemoveOfflinePlayerCommand(region, group, groupType, name);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, class_2558.class_2559.field_11750, Messages.REMOVE_CMD_COLOR);
    }
}

